/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.checksum;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import junit.framework.TestCase;
import voldemort.store.readonly.checksum.CheckSum;
import voldemort.utils.ByteUtils;

public class CheckSumTests
extends TestCase {
    public void testCheckSum() {
        CheckSum instance = CheckSum.getInstance("blah");
        CheckSumTests.assertNull((Object)instance);
        CheckSum instance2 = CheckSum.getInstance("md5");
        CheckSumTests.assertNotNull((Object)instance2);
        CheckSum instance3 = CheckSum.getInstance("crc32");
        CheckSumTests.assertNotNull((Object)instance3);
        CheckSum instance4 = CheckSum.getInstance("adler32");
        CheckSumTests.assertNotNull((Object)instance4);
        byte[] emptyBytes = new byte[]{};
        instance2.update(emptyBytes);
        CheckSumTests.assertNotNull((Object)instance2.getCheckSum());
        CheckSumTests.assertEquals((int)instance2.getCheckSum().length, (int)CheckSum.checkSumLength(CheckSum.CheckSumType.MD5));
        instance3.update(emptyBytes);
        CheckSumTests.assertNotNull((Object)instance3.getCheckSum());
        CheckSumTests.assertEquals((int)instance3.getCheckSum().length, (int)CheckSum.checkSumLength(CheckSum.CheckSumType.CRC32));
        instance4.update(emptyBytes);
        CheckSumTests.assertNotNull((Object)instance4.getCheckSum());
        CheckSumTests.assertEquals((int)instance4.getCheckSum().length, (int)CheckSum.checkSumLength(CheckSum.CheckSumType.ADLER32));
    }

    public static byte[] calculateCheckSum(File[] files, CheckSum.CheckSumType checkSumType) throws Exception {
        CheckSum checkSumGenerator = CheckSum.getInstance(checkSumType);
        CheckSum fileCheckSumGenerator = CheckSum.getInstance(checkSumType);
        int bufferSize = 65536;
        byte[] buffer = new byte[bufferSize];
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File fs1, File fs2) {
                if (fs1.isDirectory()) {
                    return fs2.isDirectory() ? 0 : -1;
                }
                if (fs1.getName().endsWith("checkSum.txt")) {
                    return -1;
                }
                if (fs2.getName().endsWith("checkSum.txt")) {
                    return 1;
                }
                if (fs1.getName().endsWith(".index")) {
                    return fs2.getName().endsWith(".index") ? 0 : 1;
                }
                return 0;
            }
        });
        for (File file : files) {
            DataInputStream is;
            if (!file.isFile() || file.getName().startsWith(".") || file.getName().contains("checkSum.txt")) continue;
            try {
                is = new DataInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                continue;
            }
            try {
                int read;
                while ((read = is.read(buffer)) >= 0) {
                    if (read < bufferSize) {
                        buffer = ByteUtils.copy((byte[])buffer, (int)0, (int)read);
                    }
                    fileCheckSumGenerator.update(buffer);
                }
                is.close();
            }
            catch (IOException e) {
                break;
            }
            checkSumGenerator.update(fileCheckSumGenerator.getCheckSum());
        }
        return checkSumGenerator.getCheckSum();
    }
}

