/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.benchmark;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import voldemort.utils.Utils;

public class GenerateData
extends Configured
implements Tool {
    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new GenerateData(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        if (args.length != 3) {
            Utils.croak((String)"USAGE: GenerateData input-file output-dir value-size");
        }
        JobConf conf = new JobConf(this.getConf(), GenerateData.class);
        conf.setJobName("generate-data");
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(GenerateDataMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        conf.setNumReduceTasks(0);
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setOutputKeyClass(BytesWritable.class);
        conf.setOutputValueClass(BytesWritable.class);
        Path inputPath = new Path(args[0]);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inputPath});
        Path outputPath = new Path(args[1]);
        FileSystem fs = outputPath.getFileSystem((Configuration)conf);
        if (fs.exists(outputPath)) {
            fs.delete(outputPath, true);
        }
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath);
        conf.setInt("value.size", Integer.parseInt(args[2]));
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GenerateDataMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, BytesWritable, BytesWritable> {
        private BytesWritable value;

        public void map(LongWritable lineNumber, Text line, OutputCollector<BytesWritable, BytesWritable> collector, Reporter reporter) throws IOException {
            collector.collect((Object)new BytesWritable(line.getBytes()), (Object)this.value);
        }

        public void configure(JobConf job) {
            StringBuilder builder = new StringBuilder();
            int size = job.getInt("value.size", -1);
            for (int i = 0; i < size; ++i) {
                builder.append('a');
            }
            this.value = new BytesWritable(builder.toString().getBytes());
        }
    }
}

