/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.benchmark;

import java.io.File;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import voldemort.cluster.Cluster;
import voldemort.store.StoreDefinition;
import voldemort.store.readonly.mr.AbstractHadoopStoreBuilderMapper;
import voldemort.store.readonly.mr.HadoopStoreBuilder;
import voldemort.utils.ByteUtils;
import voldemort.utils.Utils;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

public class BuildTestStore
extends Configured
implements Tool {
    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new BuildTestStore(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        if (args.length != 5) {
            Utils.croak((String)"Expected arguments store_name config_dir temp_dir input_path output_path");
        }
        String storeName = args[0];
        String configDir = args[1];
        String tempDir = args[2];
        String inputDir = args[3];
        String outputDir = args[4];
        List storeDefs = new StoreDefinitionsMapper().readStoreList(new File(configDir, "stores.xml"));
        StoreDefinition def = null;
        for (StoreDefinition d : storeDefs) {
            if (!d.getName().equals(storeName)) continue;
            def = d;
        }
        Cluster cluster = new ClusterMapper().readCluster(new File(configDir, "cluster.xml"));
        Configuration config = this.getConf();
        config.set("mapred.job.name", "test-store-builder");
        HadoopStoreBuilder builder = new HadoopStoreBuilder(config, BuildTestStoreMapper.class, SequenceFileInputFormat.class, cluster, def, 2, 0x60000000L, new Path(tempDir), new Path(outputDir), new Path(inputDir));
        builder.build();
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BuildTestStoreMapper
    extends AbstractHadoopStoreBuilderMapper<BytesWritable, BytesWritable> {
        @Override
        public Object makeKey(BytesWritable key, BytesWritable value) {
            return this.getValid(key);
        }

        @Override
        public Object makeValue(BytesWritable key, BytesWritable value) {
            return this.getValid(value);
        }

        private byte[] getValid(BytesWritable writable) {
            if (writable.getSize() == writable.getCapacity()) {
                return writable.get();
            }
            return ByteUtils.copy((byte[])writable.get(), (int)0, (int)writable.getSize());
        }
    }
}

