/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.mongodb;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mongodb.driver.MongoDBException;
import org.mongodb.driver.ts.Doc;
import voldemort.TestUtils;
import voldemort.VoldemortException;
import voldemort.serialization.mongodb.MongoDBDocSerializer;
import voldemort.store.AbstractStoreTest;
import voldemort.store.StorageEngine;
import voldemort.store.mongodb.MongoDBStorageEngine;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDBStorageEngineTest
extends AbstractStoreTest<ByteArray, byte[]> {
    MongoDBDocSerializer mds = new MongoDBDocSerializer();

    protected boolean valuesEqual(byte[] t1, byte[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        for (int i = 0; i < t1.length; ++i) {
            if (t1[i] == t2[i]) continue;
            return false;
        }
        return true;
    }

    public List<byte[]> getValues(int numValues) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (int i = 0; i < numValues; ++i) {
            list.add(this.mds.toBytes(new Doc("x", (Object)i)));
        }
        return list;
    }

    public List<ByteArray> getKeys(int numKeys) {
        ArrayList<ByteArray> list = new ArrayList<ByteArray>();
        StringBuffer sb = new StringBuffer("key_");
        for (int i = 0; i < numKeys; ++i) {
            sb.append(i);
            list.add(new ByteArray(sb.toString().getBytes()));
        }
        return list;
    }

    public StorageEngine<ByteArray, byte[]> getStore() {
        try {
            MongoDBStorageEngine e = new MongoDBStorageEngine("engine_tests");
            e.clearStore();
            return e;
        }
        catch (MongoDBException ee) {
            throw new VoldemortException((Throwable)ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetNoEntries() {
        ClosableIterator it = null;
        try {
            StorageEngine<ByteArray, byte[]> engine = this.getStore();
            it = engine.entries();
            while (it.hasNext()) {
                MongoDBStorageEngineTest.fail((String)"There shouldn't be any entries in this store.");
            }
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    public void testIterationWithSerialization() {
        StorageEngine<ByteArray, byte[]> store = this.getStore();
        ImmutableMap vals = ImmutableMap.of((Object)"a", (Object)"a", (Object)"b", (Object)"b", (Object)"c", (Object)"c", (Object)"d", (Object)"d", (Object)"e", (Object)"e");
        for (Map.Entry entry : vals.entrySet()) {
            store.put((Object)new ByteArray(((String)entry.getKey()).getBytes()), new Versioned((Object)this.mds.toBytes(new Doc((String)entry.getKey(), entry.getValue()))));
        }
        ClosableIterator iter = store.entries();
        int count = 0;
        while (iter.hasNext()) {
            Pair entry = (Pair)iter.next();
            String key = new String(((ByteArray)entry.getFirst()).get());
            MongoDBStorageEngineTest.assertTrue((boolean)vals.containsKey(key));
            MongoDBStorageEngineTest.assertEquals((String)((String)vals.get(key)), (String)this.mds.toObject((byte[])((Versioned)entry.getSecond()).getValue()).getString(key));
            ++count;
        }
        MongoDBStorageEngineTest.assertEquals((int)count, (int)vals.size());
        iter.close();
    }

    public void testPruneOnWrite() {
        StorageEngine<ByteArray, byte[]> engine = this.getStore();
        Doc d = new Doc("x", (Object)1);
        Versioned v1 = new Versioned((Object)this.mds.toBytes(d.add("x", (Object)1)), (Version)TestUtils.getClock((int[])new int[]{1}));
        Versioned v2 = new Versioned((Object)this.mds.toBytes(d.add("x", (Object)2)), (Version)TestUtils.getClock((int[])new int[]{2}));
        Versioned v3 = new Versioned((Object)this.mds.toBytes(d.add("x", (Object)3)), (Version)TestUtils.getClock((int[])new int[]{1, 2}));
        ByteArray key = new ByteArray("foo".getBytes());
        engine.put((Object)key, v1);
        engine.put((Object)key, v2);
        MongoDBStorageEngineTest.assertEquals((int)2, (int)engine.get((Object)key).size());
        engine.put((Object)key, v3);
        MongoDBStorageEngineTest.assertEquals((int)1, (int)engine.get((Object)key).size());
    }
}

