/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.krati;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import krati.cds.array.DataArray;
import krati.cds.impl.segment.MemorySegmentFactory;
import krati.cds.impl.segment.SegmentFactory;
import krati.cds.impl.store.DynamicDataStore;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.store.NoSuchCapabilityException;
import voldemort.store.StorageEngine;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Occured;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KratiStorageEngine
implements StorageEngine<ByteArray, byte[]> {
    private static final Logger logger = Logger.getLogger(KratiStorageEngine.class);
    private final String name;
    private DynamicDataStore datastore = null;

    public KratiStorageEngine(String name, int segmentFileSizeMB, double hashLoadFactor, int initLevel, File dataDirectory) {
        this.name = (String)Utils.notNull((Object)name);
        MemorySegmentFactory segmentFactory = new MemorySegmentFactory();
        try {
            this.datastore = new DynamicDataStore(dataDirectory, initLevel, segmentFileSizeMB, (SegmentFactory)segmentFactory, hashLoadFactor);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to initialize datastore");
            this.datastore = null;
        }
    }

    public Object getCapability(StoreCapabilityType capability) {
        throw new NoSuchCapabilityException(capability, this.getName());
    }

    public String getName() {
        return this.name;
    }

    public void close() throws VoldemortException {
    }

    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        return StoreUtils.getAll((Store)this, keys);
    }

    public List<Version> getVersions(ByteArray key) {
        return StoreUtils.getVersions(this.get(key));
    }

    public void truncate() {
        try {
            this.datastore.clear();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new VoldemortException("Failed to truncate Krati");
        }
    }

    public List<Versioned<byte[]>> get(ByteArray key) throws VoldemortException {
        StoreUtils.assertValidKey((Object)key);
        try {
            return this.disassembleValues(this.datastore.get(key.get()));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new VoldemortException("Failed to deserialize data");
        }
    }

    public ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> entries() {
        ArrayList<Pair<ByteArray, Versioned<byte[]>>> returnedList = new ArrayList<Pair<ByteArray, Versioned<byte[]>>>();
        DataArray array = this.datastore.getDataArray();
        for (int index = 0; index < array.length(); ++index) {
            List<Versioned<byte[]>> versions;
            ByteBuffer bb;
            int cnt;
            byte[] returnedBytes = array.getData(index);
            if (returnedBytes == null || (cnt = (bb = ByteBuffer.wrap(returnedBytes)).getInt()) <= 0) continue;
            int keyLen = bb.getInt();
            byte[] key = new byte[keyLen];
            bb.get(key);
            int valueLen = bb.getInt();
            byte[] value = new byte[valueLen];
            bb.get(value);
            try {
                versions = this.disassembleValues(value);
            }
            catch (IOException e) {
                versions = null;
            }
            if (versions == null) continue;
            for (Versioned<byte[]> currentVersion : versions) {
                returnedList.add((Pair<ByteArray, Versioned<byte[]>>)Pair.create((Object)new ByteArray(key), currentVersion));
            }
        }
        return new KratiClosableIterator(returnedList);
    }

    public ClosableIterator<ByteArray> keys() {
        return StoreUtils.keys(this.entries());
    }

    public boolean delete(ByteArray key, Version maxVersion) throws VoldemortException {
        StoreUtils.assertValidKey((Object)key);
        if (maxVersion == null) {
            try {
                return this.datastore.delete(key.get());
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new VoldemortException("Failed to delete key" + key);
            }
        }
        List<Versioned<byte[]>> returnedValuesList = this.get(key);
        if (returnedValuesList.size() == 0) {
            return false;
        }
        Iterator<Versioned<byte[]>> iter = returnedValuesList.iterator();
        while (iter.hasNext()) {
            Versioned<byte[]> currentValue = iter.next();
            Version currentVersion = currentValue.getVersion();
            if (currentVersion.compare(maxVersion) != Occured.BEFORE) continue;
            iter.remove();
        }
        try {
            if (returnedValuesList.size() == 0) {
                List<Versioned<byte[]>> genList = this.get(key);
                return this.datastore.delete(key.get());
            }
            return this.datastore.put(key.get(), this.assembleValues(returnedValuesList));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new VoldemortException("Failed to delete key " + key);
        }
    }

    public void put(ByteArray key, Versioned<byte[]> value) throws VoldemortException {
        StoreUtils.assertValidKey((Object)key);
        List<Versioned<byte[]>> existingValuesList = this.get(key);
        if (existingValuesList.size() == 0) {
            existingValuesList = new ArrayList<Versioned<byte[]>>();
            existingValuesList.add((Versioned<byte[]>)new Versioned(value.getValue(), value.getVersion()));
        } else {
            ArrayList<Versioned<byte[]>> removedValueList = new ArrayList<Versioned<byte[]>>();
            for (Versioned<byte[]> versioned : existingValuesList) {
                Occured occured = value.getVersion().compare(versioned.getVersion());
                if (occured == Occured.BEFORE) {
                    throw new ObsoleteVersionException("Obsolete version for key '" + key + "': " + value.getVersion());
                }
                if (occured != Occured.AFTER) continue;
                removedValueList.add(versioned);
            }
            existingValuesList.removeAll(removedValueList);
            existingValuesList.add(value);
        }
        try {
            this.datastore.put(key.get(), this.assembleValues(existingValuesList));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new VoldemortException("Failed to put key " + key);
        }
    }

    private byte[] assembleValues(List<Versioned<byte[]>> values) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(stream);
        for (Versioned<byte[]> value : values) {
            byte[] object = (byte[])value.getValue();
            dataStream.writeInt(object.length);
            dataStream.write(object);
            VectorClock clock = (VectorClock)value.getVersion();
            dataStream.writeInt(clock.sizeInBytes());
            dataStream.write(clock.toBytes());
        }
        return stream.toByteArray();
    }

    private List<Versioned<byte[]>> disassembleValues(byte[] values) throws IOException {
        if (values == null) {
            return new ArrayList<Versioned<byte[]>>(0);
        }
        ArrayList<Versioned<byte[]>> returnList = new ArrayList<Versioned<byte[]>>();
        ByteArrayInputStream stream = new ByteArrayInputStream(values);
        DataInputStream dataStream = new DataInputStream(stream);
        while (dataStream.available() > 0) {
            byte[] object = new byte[dataStream.readInt()];
            dataStream.read(object);
            byte[] clockBytes = new byte[dataStream.readInt()];
            dataStream.read(clockBytes);
            VectorClock clock = new VectorClock(clockBytes);
            returnList.add((Versioned<byte[]>)new Versioned((Object)object, (Version)clock));
        }
        return returnList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KratiClosableIterator
    implements ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> {
        private Iterator<Pair<ByteArray, Versioned<byte[]>>> iter;

        public KratiClosableIterator(List<Pair<ByteArray, Versioned<byte[]>>> list) {
            this.iter = list.iterator();
        }

        public void close() {
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Pair<ByteArray, Versioned<byte[]>> next() {
            return this.iter.next();
        }

        public void remove() {
            Pair<ByteArray, Versioned<byte[]>> currentPair = this.next();
            KratiStorageEngine.this.delete((ByteArray)currentPair.getFirst(), ((Versioned)currentPair.getSecond()).getVersion());
        }
    }
}

