/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization.mongodb;

import org.mongodb.driver.MongoDBException;
import org.mongodb.driver.impl.DirectBufferTLS;
import org.mongodb.driver.ts.Doc;
import org.mongodb.driver.util.BSONObject;
import voldemort.serialization.SerializationException;
import voldemort.serialization.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDBDocSerializer
implements Serializer<Doc> {
    public byte[] toBytes(Doc doc) {
        BSONObject bo = new BSONObject(this.getTLS().getWriteBuffer());
        try {
            bo.serialize(doc);
            return bo.toArray();
        }
        catch (MongoDBException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public Doc toObject(byte[] bytes) {
        BSONObject bo = new BSONObject(this.getTLS().getReadBuffer());
        try {
            return bo.deserialize(bytes);
        }
        catch (MongoDBException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private DirectBufferTLS getTLS() {
        DirectBufferTLS tls = DirectBufferTLS.getThreadLocal();
        if (tls == null) {
            tls = new DirectBufferTLS();
            tls.set();
        }
        return tls;
    }
}

