/*
 * Decompiled with CFR 0.152.
 */
package voldemort.hadoop.pig;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import voldemort.hadoop.VoldemortHadoopConfig;
import voldemort.hadoop.VoldemortInputFormat;
import voldemort.utils.ByteArray;
import voldemort.versioning.Versioned;

public class VoldemortStore
extends LoadFunc {
    private Configuration conf;
    private RecordReader reader;

    public InputFormat getInputFormat() throws IOException {
        VoldemortInputFormat inputFormat = new VoldemortInputFormat();
        return inputFormat;
    }

    public Tuple getNext() throws IOException {
        ByteArray key = null;
        Versioned value = null;
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            key = (ByteArray)this.reader.getCurrentKey();
            value = (Versioned)this.reader.getCurrentValue();
        }
        catch (InterruptedException e) {
            throw new IOException("Error reading in key/value");
        }
        if (key == null || value == null) {
            return null;
        }
        Tuple tuple = TupleFactory.getInstance().newTuple(2);
        tuple.set(0, (Object)new DataByteArray(key.get()));
        tuple.set(1, (Object)new String((byte[])value.getValue()));
        return tuple;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.reader = reader;
    }

    public void setLocation(String location, Job job) throws IOException {
        if (!location.startsWith("tcp://")) {
            throw new IOException("The correct format is tcp://<url:port>/storeName");
        }
        String[] subParts = location.split("/+");
        this.conf = job.getConfiguration();
        VoldemortHadoopConfig.setVoldemortURL(this.conf, subParts[0] + "//" + subParts[1]);
        VoldemortHadoopConfig.setVoldemortStoreName(this.conf, subParts[2]);
    }
}

