/*
 * Decompiled with CFR 0.152.
 */
package voldemort.hadoop;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.jdom.Content;
import voldemort.cluster.Node;
import voldemort.hadoop.VoldemortHadoopConfig;
import voldemort.hadoop.VoldemortInputFormat;
import voldemort.hadoop.VoldemortInputSplit;
import voldemort.store.readonly.mr.HadoopStoreJobRunner;
import voldemort.utils.ByteArray;
import voldemort.utils.Utils;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortWordCount
extends Configured
implements Tool {
    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new VoldemortWordCount(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            Utils.croak((String)"USAGE: java VoldemortWordCount store_name adminclient_bootstrap_url");
        }
        Configuration conf = this.getConf();
        Class[] deps = new Class[]{Node.class, VoldemortInputSplit.class, VoldemortInputFormat.class, VoldemortHadoopConfig.class, Message.class, Content.class, ImmutableList.class, IOUtils.class, RecordReader.class};
        String storeName = args[0];
        String url = args[1];
        Job job = new Job(conf, "wordcount");
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setMapperClass(SimpleTokenizer.class);
        job.setCombinerClass(IntSumReducer.class);
        job.setReducerClass(IntSumReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        VoldemortWordCount.addDepJars(job.getConfiguration(), deps);
        job.setInputFormatClass(VoldemortInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path("wordcount" + System.nanoTime()));
        VoldemortHadoopConfig.setVoldemortURL(job.getConfiguration(), url);
        VoldemortHadoopConfig.setVoldemortStoreName(job.getConfiguration(), storeName);
        job.waitForCompletion(true);
        return 0;
    }

    public static String findInClasspath(String className) {
        return VoldemortWordCount.findInClasspath(className, HadoopStoreJobRunner.class.getClassLoader());
    }

    public static String findInClasspath(String className, ClassLoader loader) {
        String codePath;
        String relPath = className;
        relPath = relPath.replace('.', '/');
        URL classUrl = loader.getResource(relPath = relPath + ".class");
        if (classUrl != null) {
            boolean inJar = classUrl.getProtocol().equals("jar");
            codePath = classUrl.toString();
            if (codePath.startsWith("jar:")) {
                codePath = codePath.substring("jar:".length());
            }
            if (codePath.startsWith("file:")) {
                codePath = codePath.substring("file:".length());
            }
            if (inJar) {
                int bang = codePath.lastIndexOf(33);
                codePath = codePath.substring(0, bang);
            } else {
                int pos = codePath.lastIndexOf(relPath);
                if (pos == -1) {
                    throw new IllegalArgumentException("invalid codePath: className=" + className + " codePath=" + codePath);
                }
                codePath = codePath.substring(0, pos);
            }
        } else {
            codePath = null;
        }
        return codePath;
    }

    private static void addDepJars(Configuration conf, Class<?>[] deps) throws IOException {
        String[] tmpjars;
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> depJars = new HashSet<String>();
        for (Class<?> dep : deps) {
            String tmp = VoldemortWordCount.findInClasspath(dep.getCanonicalName());
            if (tmp == null) continue;
            Path path = new Path(tmp);
            depJars.add(path.makeQualified((FileSystem)localFs).toString());
        }
        for (String tmpjar : tmpjars = conf.get("tmpjars", "").split(",")) {
            if (StringUtils.isEmpty((String)tmpjar)) continue;
            depJars.add(tmpjar.trim());
        }
        conf.set("tmpjars", StringUtils.join(depJars.iterator(), (char)','));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntSumReducer
    extends Reducer<Text, IntWritable, Text, IntWritable> {
        private IntWritable result = new IntWritable();

        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write((Object)key, (Object)this.result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleTokenizer
    extends Mapper<ByteArray, Versioned<byte[]>, Text, IntWritable> {
        private Text word = new Text();

        public void map(ByteArray key, Versioned<byte[]> value, Mapper.Context context) throws IOException, InterruptedException {
            String valueString = new String((byte[])value.getValue());
            StringTokenizer itr = new StringTokenizer(valueString);
            while (itr.hasMoreTokens()) {
                this.word.set(itr.nextToken());
                context.write((Object)this.word, (Object)new IntWritable(1));
            }
        }
    }
}

