/*
 * Decompiled with CFR 0.152.
 */
package voldemort.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import voldemort.cluster.Node;

public class VoldemortInputSplit
extends InputSplit
implements Writable {
    private String storeName;
    private String hostName;
    private Integer nodeId;
    private Integer adminPort;

    public VoldemortInputSplit(String storeName, Node node) {
        this.storeName = storeName;
        this.hostName = node.getHost();
        this.nodeId = node.getId();
        this.adminPort = node.getAdminPort();
    }

    public long getLength() throws IOException, InterruptedException {
        return 0L;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public Integer getAdminPort() {
        return this.adminPort;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return new String[]{this.hostName};
    }

    public void readFields(DataInput inputStream) throws IOException {
        this.storeName = inputStream.readUTF();
        this.hostName = inputStream.readUTF();
        this.nodeId = inputStream.readInt();
        this.adminPort = inputStream.readInt();
    }

    public void write(DataOutput outputStream) throws IOException {
        outputStream.writeUTF(this.storeName);
        outputStream.writeUTF(this.hostName);
        outputStream.writeInt(this.nodeId);
        outputStream.writeInt(this.adminPort);
    }

    protected VoldemortInputSplit() {
    }

    public static VoldemortInputSplit read(DataInput in) throws IOException {
        VoldemortInputSplit split = new VoldemortInputSplit();
        split.readFields(in);
        return split;
    }
}

