/*
 * Decompiled with CFR 0.152.
 */
package voldemort.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.hadoop.VoldemortHadoopConfig;
import voldemort.hadoop.VoldemortInputSplit;
import voldemort.hadoop.VoldemortRecordReader;
import voldemort.utils.ByteArray;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortInputFormat
extends InputFormat<ByteArray, Versioned<byte[]>> {
    public RecordReader<ByteArray, Versioned<byte[]>> createRecordReader(InputSplit currentSplit, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        return new VoldemortRecordReader();
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String bootstrapURL = VoldemortHadoopConfig.getVoldemortURL(conf);
        String storeName = VoldemortHadoopConfig.getVoldemortStoreName(conf);
        AdminClient adminClient = new AdminClient(bootstrapURL, new AdminClientConfig());
        Cluster cluster = adminClient.getAdminClientCluster();
        Collection nodes = cluster.getNodes();
        Iterator nodeIter = nodes.iterator();
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        while (nodeIter.hasNext()) {
            Node currentNode = (Node)nodeIter.next();
            VoldemortInputSplit split = new VoldemortInputSplit(storeName, currentNode);
            splits.add(split);
        }
        adminClient.stop();
        return splits;
    }
}

