/*
 * Decompiled with CFR 0.152.
 */
package voldemort.contrib.batchindexer.performance;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.SequenceFileRecordReader;
import voldemort.performance.PerformanceTest;
import voldemort.server.VoldemortConfig;
import voldemort.store.StorageEngine;
import voldemort.store.Store;
import voldemort.store.mysql.MysqlStorageConfiguration;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.Props;
import voldemort.utils.Utils;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Versioned;

public class MysqlBuildPerformanceTest {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length != 3) {
            Utils.croak((String)("USAGE: java " + MysqlBuildPerformanceTest.class.getName() + "serverPropsFile storeName jsonSequenceDataFile"));
        }
        String serverPropsFile = args[0];
        String storeName = args[1];
        String jsonDataFile = args[2];
        StorageEngine store = new MysqlStorageConfiguration(new VoldemortConfig(new Props(new File[]{new File(serverPropsFile)}))).getStore(storeName);
        AtomicInteger obsoletes = new AtomicInteger(0);
        Path jsonFilePath = new Path(jsonDataFile);
        FileStatus jsonFileStatus = jsonFilePath.getFileSystem(new Configuration()).listStatus(jsonFilePath)[0];
        final SequenceFileRecordReader reader = new SequenceFileRecordReader(new Configuration(), new FileSplit(jsonFilePath, 0L, jsonFileStatus.getLen(), (String[])null));
        PerformanceTest readWriteTest = new PerformanceTest((Store)store, obsoletes){
            final /* synthetic */ Store val$store;
            final /* synthetic */ AtomicInteger val$obsoletes;
            {
                this.val$store = store;
                this.val$obsoletes = atomicInteger;
            }

            public void doOperation(int index) throws Exception {
                try {
                    BytesWritable key = new BytesWritable();
                    BytesWritable value = new BytesWritable();
                    reader.next((Object)key, (Object)value);
                    this.val$store.put((Object)new ByteArray(ByteUtils.copy((byte[])key.get(), (int)0, (int)key.getSize())), Versioned.value((Object)ByteUtils.copy((byte[])value.get(), (int)0, (int)value.getSize())));
                }
                catch (ObsoleteVersionException e) {
                    this.val$obsoletes.incrementAndGet();
                }
            }
        };
        readWriteTest.run(1000, 1);
        System.out.println("MySQl write throuhput with one thread:");
        readWriteTest.printStats();
    }
}

