/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import org.mongodb.driver.ts.Doc;
import voldemort.client.ClientConfig;
import voldemort.client.SocketStoreClientFactory;
import voldemort.client.StoreClient;
import voldemort.client.StoreClientFactory;
import voldemort.serialization.SerializerFactory;
import voldemort.serialization.mongodb.MongoDBSerializationFactory;
import voldemort.versioning.Versioned;

public class MongoDBClient {
    protected final StoreClientFactory factory;
    Random rand = new Random();

    public MongoDBClient(String bootstrapUrl) {
        this.factory = new SocketStoreClientFactory(new ClientConfig().setSerializerFactory((SerializerFactory)new MongoDBSerializationFactory()).setBootstrapUrls(new String[]{bootstrapUrl}));
    }

    public long multiWriteLarge(int count, String keyRoot) {
        StoreClient client = this.factory.getStoreClient("test");
        long start = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            Doc d = this.makeLargeDoc();
            d.add("x", (Object)1);
            Versioned v = new Versioned((Object)d);
            client.put((Object)(keyRoot + i), v);
        }
        long end = System.currentTimeMillis();
        return end - start;
    }

    public long multiWrite(int count, String keyRoot) {
        StoreClient client = this.factory.getStoreClient("test");
        long start = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            Doc d = new Doc("name", (Object)"geir");
            d.add("x", (Object)1);
            Versioned v = new Versioned((Object)d);
            client.put((Object)(keyRoot + i), v);
        }
        long end = System.currentTimeMillis();
        return end - start;
    }

    public long multiRead(int count, String keyRoot) {
        StoreClient client = this.factory.getStoreClient("test");
        long start = System.currentTimeMillis();
        int found = 0;
        for (int i = 0; i < count; ++i) {
            Versioned v = client.get((Object)(keyRoot + i));
            if (v == null) continue;
            ++found;
        }
        long end = System.currentTimeMillis();
        System.out.println("Found : " + found);
        return end - start;
    }

    public String getRandomKey(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(this.rand.nextInt(9));
        }
        return sb.toString();
    }

    public void simple() {
        StoreClient client = this.factory.getStoreClient("test");
        Versioned v = client.get((Object)"key");
        if (v == null) {
            Doc d = new Doc("name", (Object)"geir");
            d.add("x", (Object)1);
            v = new Versioned((Object)d);
        }
        client.put((Object)"key", v);
        v = client.get((Object)"key");
        System.out.println("value : " + v.getValue());
        System.out.println("clock : " + v.getVersion());
    }

    public Doc makeLargeDoc() {
        Doc d = new Doc();
        d.add("pb_id", (Object)2321232);
        d.add("base_url", (Object)"http://www.example.com/test-me");
        d.add("total_word_count", (Object)6743);
        d.add("access_time", (Object)1234915320);
        Doc mt = new Doc();
        mt.add("description", (Object)"i am a long description string");
        mt.add("author", (Object)"Holly man");
        mt.add("dynamically_created_meta_tag", (Object)"who know what");
        d.add("meta_tags", (Object)mt);
        mt = new Doc();
        mt.add("counted_tags", (Object)3450);
        mt.add("no_of_js_attached", (Object)10);
        mt.add("no_of_images", (Object)6);
        d.put("page_structure", (Object)mt);
        mt = new Doc();
        for (int i = 0; i < 10; ++i) {
            mt.add(Integer.toString(i), (Object)"woog");
        }
        d.add("harvested_words", (Object)mt);
        return d;
    }

    public static void main(String[] args) {
        MongoDBClient client = new MongoDBClient("tcp://localhost:6666");
        client.simple();
        String keyRoot = client.getRandomKey(15);
        System.out.println(10000.0 / (double)client.multiWrite(10000, keyRoot) * 1000.0 + " writes per sec");
        System.out.println(10000.0 / (double)client.multiRead(10000, keyRoot) * 1000.0 + " reads per sec");
        keyRoot = client.getRandomKey(15);
        System.out.println(10000.0 / (double)client.multiWriteLarge(10000, keyRoot) * 1000.0 + " large writes per sec");
    }
}

