/*
 * Decompiled with CFR 0.152.
 */
package vivid.polypara.maven;

import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.collection.SortedMap;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import vivid.polypara.maven.ConstancyViolation;
import vivid.polypara.maven.ConstantsData;
import vivid.polypara.maven.Mojo;
import vivid.polypara.maven.SimpleVersionRange;
import vivid.polypara.maven.SneakyMojoException;
import vivid.polypara.maven.Static;
import vivid.polypara.maven.VPE1InternalError;

class ConstantsGraphImpl
implements ConstantsData {
    private final GraphDatabaseService db;
    private final Path dbTempDirectory;
    private final HashMap<Object, Object> fieldValueStore;
    private final Mojo mojo;
    private final List<String> versionStrings;
    private static final String FIELD_FULLY_QUALIFIED_NAME_PROPERTY = "fqn";
    private static final String FIELD_VALUE_ID_PROPERTY = "valueID";
    private static final String VERSION_STRING_PROPERTY = "version";
    private static final String VERSION_ORDINAL_PROPERTY = "ordinal";

    ConstantsGraphImpl(Mojo mojo, List<String> versionStrings) throws IOException {
        this.mojo = mojo;
        this.versionStrings = versionStrings;
        this.dbTempDirectory = Files.createTempDirectory("polypara", new FileAttribute[0]);
        this.db = new GraphDatabaseFactory().newEmbeddedDatabase(this.dbTempDirectory.toFile());
        this.createConstraints();
        this.createArtifactVersionNodes(versionStrings);
        mojo.getLog().debug((CharSequence)("Instantiated a new database in " + this.dbTempDirectory));
        this.fieldValueStore = new HashMap();
    }

    private String recordFieldValue(Object fieldValue) {
        String fieldID = UUID.randomUUID().toString();
        this.fieldValueStore.put(fieldID, fieldValue);
        return fieldID;
    }

    @Override
    public void close() {
        this.db.shutdown();
        try {
            FileUtils.deleteDirectory((File)this.dbTempDirectory.toFile());
        }
        catch (IOException e) {
            this.mojo.getLog().info((CharSequence)("Could not delete temporary DB directory: " + this.dbTempDirectory), (Throwable)e);
        }
    }

    private void createArtifactVersionNodes(List<String> versions) {
        this.withinTransaction(() -> {
            Function<Tuple2, Node> createVersionNode = versionDesc -> {
                Node node = this.db.createNode(new Label[]{NodeLabels.VERSION});
                node.setProperty(VERSION_STRING_PROPERTY, versionDesc._1);
                node.setProperty(VERSION_ORDINAL_PROPERTY, versionDesc._2);
                return node;
            };
            BinaryOperator relateVersionNodes = (cursor, next) -> {
                cursor.createRelationshipTo(next, (RelationshipType)RelationshipTypes.NEXT_VERSION);
                return next;
            };
            Stream versionOrder = Stream.iterate((Object)0, i -> i + 1);
            this.mojo.getLog().debug((CharSequence)("Creating graph nodes for versions:  " + Static.humanReadableVersionList(versions)));
            versions.zip((Iterable)versionOrder).map(createVersionNode).reduceLeft((BiFunction)relateVersionNodes);
        });
    }

    private void createConstraints() {
        this.mojo.getLog().debug((CharSequence)"Creating graph database constraints");
        this.withinTransaction(() -> {
            this.db.schema().constraintFor((Label)NodeLabels.CONSTANT_FIELD).assertPropertyIsUnique(FIELD_FULLY_QUALIFIED_NAME_PROPERTY).create();
            this.db.schema().constraintFor((Label)NodeLabels.VERSION).assertPropertyIsUnique(VERSION_STRING_PROPERTY).create();
            this.db.schema().constraintFor((Label)NodeLabels.VERSION).assertPropertyIsUnique(VERSION_ORDINAL_PROPERTY).create();
        });
    }

    private Node findOrCreateNode(Label label, String key, Object value) {
        Node existingNode = this.db.findNode(label, key, value);
        if (existingNode != null) {
            return existingNode;
        }
        Node newNode = this.db.createNode(new Label[]{label});
        newNode.setProperty(key, value);
        return newNode;
    }

    private Node retrieveVersionNode(String version) {
        return this.db.findNode((Label)NodeLabels.VERSION, VERSION_STRING_PROPERTY, (Object)version);
    }

    @Override
    public void recordConstantFields(String version, List<Tuple2<String, Object>> fields) {
        fields.forEach(f -> this.recordConstantField(version, (Tuple2<String, Object>)f));
    }

    private void recordConstantField(String version, Tuple2<String, Object> field) {
        this.withinTransaction(() -> {
            Node fieldNode = this.findOrCreateNode(NodeLabels.CONSTANT_FIELD, FIELD_FULLY_QUALIFIED_NAME_PROPERTY, field._1);
            Node versionNode = this.retrieveVersionNode(version);
            Relationship r = fieldNode.createRelationshipTo(versionNode, (RelationshipType)RelationshipTypes.FIELD_INSTANCE);
            String fieldID = this.recordFieldValue(field._2);
            r.setProperty(FIELD_VALUE_ID_PROPERTY, (Object)fieldID);
        });
    }

    private void withinTransaction(Runnable runnable) {
        try (Transaction tx = this.db.beginTx();){
            runnable.run();
            tx.success();
        }
    }

    @Override
    public int constantFieldsCount() {
        ResourceIterator resultIterator = this.db.execute("MATCH (n:CONSTANT_FIELD) RETURN count(n) as count").columnAs("count");
        Object result = resultIterator.next();
        return Integer.parseInt(result.toString());
    }

    @Override
    public List<ConstancyViolation> constancyViolationDescriptions() {
        ArrayList violations = new ArrayList();
        this.withinTransaction(() -> {
            ResourceIterator fields = this.db.findNodes((Label)NodeLabels.CONSTANT_FIELD);
            fields.forEachRemaining(field -> {
                SortedMap fineHistory;
                String fullyQualifiedFieldName = String.valueOf(field.getProperty(FIELD_FULLY_QUALIFIED_NAME_PROPERTY));
                SortedMap version2value = this.versionStrings.toSortedMap(v -> v, v -> Option.none());
                Iterable fieldInstances = field.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipTypes.FIELD_INSTANCE});
                BiFunction<SortedMap, Relationship, SortedMap> noteFieldInstanceValue = (v2v, r) -> v2v.put((Object)String.valueOf(r.getEndNode().getProperty(VERSION_STRING_PROPERTY)), (Object)Option.of((Object)this.fieldValueStore.get(r.getProperty(FIELD_VALUE_ID_PROPERTY))));
                Predicate<Tuple2> undefVal = e -> ((Option)e._2).isEmpty();
                SortedMap valueByVersion = ((SortedMap)Stream.ofAll((Iterable)fieldInstances).foldLeft((Object)version2value, noteFieldInstanceValue)).map((ver, val) -> new Tuple2((Object)new SimpleVersionRange((String)ver, (Option<String>)Option.none()), val));
                BiFunction<SortedMap, Tuple2, SortedMap> collapseAdjacentEntriesOfEqualValue = (v2v, cur) -> {
                    Tuple2 prev = v2v.last();
                    if (((Option)prev._2).equals(cur._2)) {
                        return v2v.dropRight(1).put((Object)new SimpleVersionRange(((SimpleVersionRange)prev._1).start, (Option<String>)Option.of((Object)((SimpleVersionRange)cur._1).start)), prev._2);
                    }
                    return v2v.put(cur);
                };
                SortedMap roughHistory = (SortedMap)valueByVersion.drop(1).foldLeft((Object)valueByVersion.take(1), collapseAdjacentEntriesOfEqualValue);
                UnaryOperator trimUndefValEnds = hist -> {
                    SortedMap histHead = undefVal.test((Tuple2)roughHistory.take(1).get()) ? hist.drop(1) : hist;
                    return undefVal.test((Tuple2)histHead.takeRight(1).get()) ? histHead.dropRight(1) : histHead;
                };
                SortedMap sortedMap = fineHistory = roughHistory.size() >= 2 ? (SortedMap)trimUndefValEnds.apply(roughHistory) : roughHistory;
                if (fineHistory.isEmpty()) {
                    throw new SneakyMojoException((Throwable)new MojoExecutionException(VPE1InternalError.message(String.format("Field %s was recorded as being subject to @Constant constraints but was calculated as not being defined in any version", fullyQualifiedFieldName)).render(this.mojo)));
                }
                if (fineHistory.length() >= 2) {
                    ConstancyViolation cv = new ConstancyViolation(fullyQualifiedFieldName, (List<Tuple2<SimpleVersionRange, Option<Object>>>)fineHistory.toList());
                    violations.add(cv);
                }
            });
        });
        return List.ofAll(violations);
    }

    private static enum RelationshipTypes implements RelationshipType
    {
        FIELD_INSTANCE,
        NEXT_VERSION;

    }

    private static enum NodeLabels implements Label
    {
        VERSION,
        CONSTANT_FIELD;

    }
}

