/*
 * Decompiled with CFR 0.152.
 */
package vivid.cherimoya.maven;

import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.control.Either;
import java.io.File;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.objectweb.asm.ClassReader;
import vivid.cherimoya.maven.AsmClassReaders;
import vivid.cherimoya.maven.CE3ArtifactResolutionFailure;
import vivid.cherimoya.maven.Message;
import vivid.cherimoya.maven.Mojo;
import vivid.cherimoya.maven.Static;

class MavenArtifactResolution {
    private MavenArtifactResolution() {
    }

    static Either<Message, Map<String, List<ClassReader>>> mapVersionsToClassReaders(Mojo mojo, List<String> resolvableVersions) {
        Either<Message, List<ClassReader>> currentVersionClassReaders = AsmClassReaders.fromFile(mojo, new File(mojo.getMavenProject().getBuild().getOutputDirectory()));
        Either mapping = currentVersionClassReaders.map(val -> HashMap.of((Object)mojo.getMavenProject().getVersion(), (Object)val));
        return (Either)resolvableVersions.foldLeft((Object)mapping, (m, version) -> {
            if (m.isLeft()) {
                return m;
            }
            Either<Message, List<ClassReader>> ret = MavenArtifactResolution.classReaderForResolvableVersion(mojo, mojo.getMavenProject().getGroupId(), mojo.getMavenProject().getArtifactId(), version);
            if (ret.isLeft()) {
                return Either.left((Object)ret.getLeft());
            }
            return Either.right((Object)((Map)m.get()).put(version, ret.get()));
        });
    }

    private static Either<Message, List<ClassReader>> classReaderForResolvableVersion(Mojo mojo, String groupId, String artifactId, String version) {
        return MavenArtifactResolution.resolveArtifact(mojo, groupId, artifactId, version).flatMap(ar -> AsmClassReaders.fromJarFile(mojo, ar.getArtifact().getFile()));
    }

    private static Either<Message, ArtifactResult> resolveArtifact(Mojo mojo, String groupId, String artifactId, String version) {
        String gav = Static.mavenGAVOf(groupId, artifactId, version);
        DefaultArtifact artifact = new DefaultArtifact(gav);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        artifactRequest.setRepositories(mojo.getRemoteRepositories());
        try {
            return Either.right((Object)mojo.getRepositorySystem().resolveArtifact(mojo.getRepositorySystemSession(), artifactRequest));
        }
        catch (ArtifactResolutionException e) {
            return Either.left((Object)CE3ArtifactResolutionFailure.message(gav, (Exception)((Object)e)));
        }
    }
}

