/*
 * Decompiled with CFR 0.152.
 */
package vivid.cherimoya.maven;

import io.vavr.Tuple2;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.i18n.I18N;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.objectweb.asm.ClassReader;
import vivid.cherimoya.annotation.Constant;
import vivid.cherimoya.maven.AsmFieldAnnotationScanner;
import vivid.cherimoya.maven.AsmScanner;
import vivid.cherimoya.maven.CE1InternalError;
import vivid.cherimoya.maven.ConstancyViolation;
import vivid.cherimoya.maven.ConstantsGraphImpl;
import vivid.cherimoya.maven.I18nContext;
import vivid.cherimoya.maven.MavenArtifactResolution;
import vivid.cherimoya.maven.MavenLogReporting;
import vivid.cherimoya.maven.Mojo;
import vivid.cherimoya.maven.SneakyMojoException;
import vivid.cherimoya.maven.Static;

@org.apache.maven.plugins.annotations.Mojo(name="verify", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class VerifyConstantsMojo
extends AbstractMojo
implements Mojo {
    private I18nContext i18nContext;
    @Component
    private I18N i18n;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepositories;
    @Parameter(alias="versions")
    private List<String> specifiedVersions;
    @Parameter(property="cherimoya.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="reportingLevel", defaultValue="ERROR")
    private ReportingLevel reportingLevel;

    @Override
    public I18nContext getI18nContext() {
        return this.i18nContext;
    }

    @Override
    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    @Override
    public ReportingLevel getReportingLevel() {
        return this.reportingLevel;
    }

    @Override
    public List<RemoteRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    @Override
    public RepositorySystemSession getRepositorySystemSession() {
        return this.repositorySystemSession;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.i18nContext = new I18nContext(this.i18n);
        if (this.skip) {
            this.getLog().info((CharSequence)this.i18nContext.getText("vivid.cherimoya.action.skipping-execution-via-configuration", "cherimoya.skip"));
            return;
        }
        io.vavr.collection.List allVersions = io.vavr.collection.List.ofAll((Iterable)(this.specifiedVersions != null ? this.specifiedVersions : io.vavr.collection.List.empty())).append((Object)this.mavenProject.getVersion()).distinct();
        io.vavr.collection.List resolvableVersions = allVersions.remove((Object)this.mavenProject.getVersion());
        if (allVersions.size() == 1) {
            this.getLog().warn((CharSequence)this.i18nContext.getText("vivid.cherimoya.warning.cw-1-skipping-execution-due-to-singular-version", this.mavenProject.getVersion(), Static.mavenGAOf(this.mavenProject)));
            return;
        }
        this.getLog().info((CharSequence)this.i18nContext.getText("vivid.cherimoya.action.verifying-constants", allVersions.size(), Static.mavenGAOf(this.mavenProject), Static.humanReadableVersionList((io.vavr.collection.List<String>)allVersions)));
        try (ConstantsGraphImpl constantsData = new ConstantsGraphImpl(this, (io.vavr.collection.List<String>)allVersions);){
            MavenArtifactResolution.mapVersionsToClassReaders(this, (io.vavr.collection.List<String>)resolvableVersions).map((v, cr) -> new Tuple2(v, AsmScanner.scan(new AsmFieldAnnotationScanner(this, Constant.class), (io.vavr.collection.List<ClassReader>)io.vavr.collection.List.ofAll((Iterable)cr)))).forEach(constantsData::recordConstantFields);
            this.getLog().info((CharSequence)this.i18nContext.getText("vivid.cherimoya.action.found-n-constant-fields", constantsData.constantFieldsCount(), Static.mavenGAOf(this.mavenProject)));
            io.vavr.collection.List<ConstancyViolation> violations = constantsData.constancyViolationDescriptions();
            MavenLogReporting.report(this, violations);
            if (!violations.isEmpty() && this.reportingLevel == ReportingLevel.ERROR) {
                throw new MojoFailureException(this.i18nContext.getText("vivid.cherimoya.error.ce-2-field-value-constancy-verification-failed", new Object[0]));
            }
        }
        catch (SneakyMojoException e) {
            throw SneakyMojoException.unwrap(e);
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw CE1InternalError.asNewMojoExecutionException(this, "Unexpected exception", e);
        }
    }

    static enum ReportingLevel {
        WARNING,
        ERROR;

    }
}

