/*
 * Decompiled with CFR 0.152.
 */
package vivid.cherimoya.maven;

import io.vavr.collection.List;
import java.io.File;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.maven.project.MavenProject;
import vivid.cherimoya.annotation.Constant;

class Static {
    private static final String CONSTANT_REASON = "Users prefer their existing Maven POM Cherimoya configuration to remain compatible as-is with newer versions of this Cherimoya Maven plugin.";
    @Constant(rationale={"Users prefer their existing Maven POM Cherimoya configuration to remain compatible as-is with newer versions of this Cherimoya Maven plugin."})
    static final String POM_CHERIMOYA_REPORTING_LEVEL_CONFIGURATION_KEY = "reportingLevel";
    @Constant(rationale={"Users prefer their existing Maven POM Cherimoya configuration to remain compatible as-is with newer versions of this Cherimoya Maven plugin."})
    static final String POM_CHERIMOYA_SKIP_PROPERTY_KEY = "cherimoya.skip";
    @Constant(rationale={"Users prefer their existing Maven POM Cherimoya configuration to remain compatible as-is with newer versions of this Cherimoya Maven plugin."})
    static final String POM_CHERIMOYA_VERIFY_MOJO_NAME = "verify";
    @Constant(rationale={"Users prefer their existing Maven POM Cherimoya configuration to remain compatible as-is with newer versions of this Cherimoya Maven plugin."})
    static final String POM_CHERIMOYA_VERSIONS_CONFIGURATION_KEY = "versions";
    private static final String ABBREVIATION_SUFFIX = "...";

    private Static() {
    }

    static <T> Stream<T> enumerationAsStream(final Enumeration<T> e) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (e.hasMoreElements()) {
                    action.accept(e.nextElement());
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                while (e.hasMoreElements()) {
                    action.accept(e.nextElement());
                }
            }
        }, false);
    }

    static String fieldFullyQualifiedName(String clazzName, String fieldName) {
        Objects.requireNonNull(clazzName, "clazzName is null");
        Objects.requireNonNull(fieldName, "fieldName is null");
        return String.format("%s.%s", clazzName, fieldName);
    }

    static String humanReadableVersionList(List<String> versions) {
        Objects.requireNonNull(versions, "versions is null");
        return (String)io.vavr.collection.Stream.ofAll(versions).intersperse((Object)"  ").fold((Object)"", String::concat);
    }

    static String mavenGAOf(MavenProject mavenProject) {
        Objects.requireNonNull(mavenProject, "mavenProject is null");
        return String.format("%s:%s", mavenProject.getModel().getGroupId(), mavenProject.getModel().getArtifactId());
    }

    static String mavenGAVOf(String groupId, String artifactId, String version) {
        Objects.requireNonNull(groupId, "groupId is null");
        Objects.requireNonNull(artifactId, "artifactId is null");
        Objects.requireNonNull(version, "version is null");
        return String.format("%s:%s:%s", groupId, artifactId, version);
    }

    static String objectValueAsAbbreviatedString(Object obj, int maximumStringLength) {
        String str = String.valueOf(obj);
        if (str.length() <= Math.max(ABBREVIATION_SUFFIX.length(), maximumStringLength)) {
            return str;
        }
        return String.format("%s%s", str.substring(0, maximumStringLength - ABBREVIATION_SUFFIX.length()), ABBREVIATION_SUFFIX);
    }

    static String pathInJarFile(File jarFile, String entryName) {
        Objects.requireNonNull(jarFile, "jarFile is null");
        Objects.requireNonNull(entryName, "entryName is null");
        return String.format("%s(%s)", jarFile.getAbsolutePath(), entryName);
    }
}

