/*
 * Decompiled with CFR 0.152.
 */
package vivid.cherimoya.maven;

import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.compress.utils.IOUtils;
import org.objectweb.asm.ClassReader;
import vivid.cherimoya.maven.CE4ClassReadFailure;
import vivid.cherimoya.maven.JavaClasses;
import vivid.cherimoya.maven.Mojo;
import vivid.cherimoya.maven.SneakyMojoException;
import vivid.cherimoya.maven.Static;

class AsmClassReaders {
    private AsmClassReaders() {
    }

    private static Option<ClassReader> classReaderOf(Mojo mojo, Path path) {
        try {
            if (!JavaClasses.isJavaClassFilename(path.toString())) {
                mojo.getLog().debug((CharSequence)("Ignoring re Java class file name extension: " + path));
                return Option.none();
            }
            byte[] bytes = IOUtils.toByteArray((InputStream)new FileInputStream(path.toFile()));
            if (!JavaClasses.hasJavaClassFileMagic(bytes)) {
                mojo.getLog().debug((CharSequence)("Ignoring re Java .class file header magic: " + path));
                return Option.none();
            }
            return Option.of((Object)new ClassReader(bytes));
        }
        catch (IOException e) {
            throw new SneakyMojoException(CE4ClassReadFailure.asMessage(mojo, path.toString()), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Option<ClassReader> classReaderOf(Mojo mojo, File file, JarFile jarFile, JarEntry jarEntry) {
        if (!JavaClasses.isJavaClassFilename(jarEntry.getName())) {
            mojo.getLog().debug((CharSequence)("Ignoring re Java class file name extension: " + Static.pathInJarFile(file, jarEntry.getName())));
            return Option.none();
        }
        try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            if (!JavaClasses.hasJavaClassFileMagic(bytes)) {
                mojo.getLog().debug((CharSequence)("Ignoring re Java .class file header magic: " + jarEntry.getName()));
                Option option = Option.none();
                return option;
            }
            mojo.getLog().debug((CharSequence)("Queueing Java class file: " + Static.pathInJarFile(file, jarEntry.getName())));
            Option option = Option.of((Object)new ClassReader(bytes));
            return option;
        }
        catch (IOException e) {
            throw new SneakyMojoException(CE4ClassReadFailure.asMessage(mojo, jarFile.toString()), e);
        }
    }

    private static Stream<JarEntry> streamOfJarEntries(JarFile jarFile) {
        return Stream.ofAll(Static.enumerationAsStream(jarFile.entries()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<ClassReader> fromJarFile(Mojo mojo, File file) {
        mojo.getLog().debug((CharSequence)("Examining Jar file " + file.getAbsolutePath()));
        try (JarFile jarFile = new JarFile(file);){
            List list = AsmClassReaders.streamOfJarEntries(jarFile).map(e -> AsmClassReaders.classReaderOf(mojo, file, jarFile, e)).flatMap(t -> t).toJavaList();
            return list;
        }
        catch (IOException e2) {
            throw new SneakyMojoException(CE4ClassReadFailure.asMessage(mojo, file.getAbsolutePath()), e2);
        }
    }

    private static Stream<Path> streamOfPaths(File file) throws IOException {
        return Stream.ofAll(Files.walk(file.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])));
    }

    static List<ClassReader> fromFile(Mojo mojo, File file) {
        mojo.getLog().debug((CharSequence)("Examining file " + file.getAbsolutePath()));
        try {
            return AsmClassReaders.streamOfPaths(file).map(p -> AsmClassReaders.classReaderOf(mojo, p)).flatMap(t -> t).toJavaList();
        }
        catch (IOException e) {
            throw new SneakyMojoException(CE4ClassReadFailure.asMessage(mojo, file.getAbsolutePath()), e);
        }
    }
}

