(ns zookareg.zookeeper
  "Utilities for starting and halting an embedded Curator (Zookeeper)
  TestingServer."
  (:require [integrant.core :as ig])
  (:import org.apache.curator.test.TestingServer))

(defn  ->zk
  "Starts a Curator (Zookeeper) TestingServer on port."
  [^long port]
  (TestingServer. port))

(defn halt!
  "Stops a running TestingServer."
  [^TestingServer zk]
  (when zk
    (.close zk)))

(defmethod ig/init-key ::zookeeper [_ {:keys [ports]}]
  (->zk (:zookeeper ports)))

(defmethod ig/halt-key! ::zookeeper [_ zk]
  (halt! zk))

