# zookareg [![pipeline status](https://gitlab.com/vise890/zookareg/badges/master/pipeline.svg)](https://gitlab.com/vise890/zookareg/commits/master)

Embedded **Zo**okeeper **Ka**fka and Confluent's Schema **Reg**istry.

## [API Docs](https://vise890.gitlab.io/zookareg/)

## Usage

[![Clojars Project](https://img.shields.io/clojars/v/vise890/zookareg.svg)](https://clojars.org/vise890/zookareg)
```clojure
;; in project.clj
[vise890/zookareg "1.0.0-1"]
```

### TL;DR

```clojure
(require 'zookareg.core)

(with-zookareg-fn
  (fn []
     ;; your work here
     ,,,))
```

### Development:

```clojure
(require 'zookareg.core)

;; Start an embedded system with default ports:
;; zookeeper: 2181; kafka: 9092; schema registry: 8081
(init-zookareg)

;; another call will halt the previous system:
(init-zookareg)

;; When you're done:
(halt-zookareg!)
```

### `clojure.test`:

**NOTE**: these will halt running zookareg instances

```clojure
(require 'clojure.test)
(require 'zookareg.core)

(use-fixtures :once with-zookareg-fn)
```

### Other Goodies

```clojure
;; Specify ports & kafka-overrides:
(init-zookareg (->config {:kafka           9092
                          :zookeeper       2181
                          :schema-registry 8081}
                         {:log.dir "/tmp/kafka-log"}))

;; Random-ish available ports:
(init-zookareg (->available-ports-config))
```

Happy testing!

### Versions

Zookareg versions use this format:

```bash
${kafka_version}-${build_number}
```

For example:

```ruby
0.10.0-4 # Kafka v = 0.10.0, Zookareg build = 4
1.0.1-1  # Kafka v = 1.0.1, Zookareg build = 1
```

## Default Config

```clojure
{:ports {:kafka 9092, :zookeeper 2181, :schema-registry 8081},

 :kafka-config
 {:message.send.max.retries         5,
  :broker.id                        0,
  :offsets.topic.replication.factor 1,
  :log.dir                          "/tmp/kafka-log1520720965560-1219532724",
  :zookeeper.connect                "127.0.0.1:2181",
  :retry.backoff.ms                 500,
  :bootstrap.servers                "localhost:9092",
  :auto.create.topics.enable        true,
  :group.id                         "consumer",
  :auto.commit.enable               false,
  :listeners                        "PLAINTEXT://localhost:9092",
  :log.flush.interval.messages      1,
  :zookeeper-port                   "2181"},

 :schema-registry-config
 {:listeners                           "http://0.0.0.0:8081",
  :kafkastore.connection.url           "localhost:2181",
  :kafkastore.bootstrap.servers        "PLAINTEXT://localhost:9092",
  :kafkastore.topic.replication.factor 1}}
```

## License

Copyright © 2017 Martino Visintin & Contributors

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
