(ns zookareg.zookeeper
  (:require [integrant.core :as ig])
  (:import java.lang.Integer
           org.apache.curator.test.TestingServer))

(defn ->zk [^long port] (TestingServer. port))

(defn halt! [^TestingServer zk]
  (when zk
    (.close zk)))

(defmethod ig/init-key ::zookeeper [_ {:keys [ports]}]
  (->zk (:zookeeper ports)))

(defmethod ig/halt-key! ::zookeeper [_ zk]
  (halt! zk))

