(ns zookareg)

(def ^:private zookareg (atom nil))

(def zookareg-config
  {:schema-registry/schema-registry {:properties-file "dev/resources/schema-registry.properties"
                                     :_kafka          (ig/ref :kafka/kafka)
                                     :_zookeeper      (ig/ref :zookeeper/zookeeper)}
   :kafka/kafka                     {:_zookeeper (ig/ref :zookeeper/zookeeper)}
   :zookeeper/zookeeper             {}})

(defn start-zookareg []
  (try
    (swap! zookareg ig/halt!)
    (ig/load-namespaces zookareg-config)
    (reset! zookareg (ig/init zookareg-config))
    (catch clojure.lang.ExceptionInfo ex
      (ig/halt! (:system (ex-data ex)))
      (throw (.getCause ex)))))
