(ns user
  (:require [flow-redeemer-clj.core :as core]
            [integrant.core :as ig]
            [integrant.repl :as igr]))


(igr/set-prep! core/ig-config)

(defn go
  []
  (try
    (igr/go)
    (catch clojure.lang.ExceptionInfo ex
      (ig/halt! (:system (ex-data ex)))
      (throw (.getCause ex)))))

(comment
  ;;;;
  (ig/load-namespaces ig-config)

  (go)

  integrant.repl.state/config

  integrant.repl.state/system

  (igr/halt)
  ;;;;
)
