(ns systema.core
  (:require [aero.core :as aero]
            [integrant.core :as ig]))

(defn- def-ig-key-[]
  (defmethod aero/reader 'ig/key [_ _ value] value))
(defn- def-ig-key+ [ig-keys]
  (defmethod aero/reader 'ig/key
    [_ _ k]
    (swap! ig-keys conj k) k))
(def-ig-key-)

(defmethod aero/reader 'ig/ref [_ _ value] (ig/ref value))
;; TODO add ig/refset when it lands in stable

(defn read-ig-config
  "Reads an Integrant config from `source`, returning only the keys marked with
  the tag `#ig/key`.

  Takes same arguments as `aero.core/read-config`."
  ([source]
   (read-ig-config source {}))
  ([source given-opts]
   (let [ig-keys   (atom #{})
         _         (def-ig-key+ ig-keys)
         ig-config (select-keys (aero/read-config source given-opts)
                                @ig-keys)
         _         (def-ig-key-)]
     ig-config)))
