(ns scribe.time.joda.date-time
  "Utilities and implementations of `scribe.time.core` conversions for
  `org.joda.time.LocalTime`."
  (:require [scribe.time.core :as t])
  (:import [org.joda.time DateTime DateTimeZone Instant]))

(def ^DateTimeZone ^:private utc (DateTimeZone/UTC))

(defmethod t/instant? org.joda.time.DateTime [_] true)

(defmethod t/to-epoch-milli org.joda.time.DateTime
  [^DateTime dt]
  (-> dt (.toDateTime utc) .toInstant .getMillis))

(defmethod t/of-epoch-milli org.joda.time.DateTime
  [_ ^long ms]
  (-> ms Instant. (DateTime. utc)))
