(ns scribe.time.joda.local-time
  "Utilities and implementations of `scribe.time.core` conversions for
  `org.joda.time.LocalTime`."
  (:require [scribe.time.core :as cs])
  (:import org.joda.time.LocalTime))

(defn ^LocalTime now [] (LocalTime/now))

(defmethod cs/local-time? org.joda.time.LocalTime [_] true)

(defmethod cs/to-milli-of-day org.joda.time.LocalTime
  [^LocalTime lt]
  (.getMillisOfDay lt))

(defmethod cs/of-milli-of-day org.joda.time.LocalTime
  [_ ms]
  (-> (LocalTime. (int 0) (int 0))
      (.plusMillis ms)))
