(ns scribe.time.joda.local-date
  "Utilities and implementations of `scribe.time.core` conversions for
  `org.joda.time.LocalDate`."
  (:require [scribe.time.core :as cs])
  (:import org.joda.time.LocalDate))

(defn now ^LocalDate [] (LocalDate/now))

(defmethod cs/local-date? org.joda.time.LocalDate [_] true)

(defmethod cs/to-epoch-day org.joda.time.LocalDate
  [^LocalDate ld]
  (let [ld (java.time.LocalDate/of (.getYear ld)
                                   (.getMonthOfYear ld)
                                   (.getDayOfMonth ld))]
    (.toEpochDay ld)))

(defmethod cs/of-epoch-day org.joda.time.LocalDate
  [_ days]
  (let [ld (java.time.LocalDate/ofEpochDay days)]
    (LocalDate. (.getYear ld) (.getMonthValue ld) (.getDayOfMonth ld))))
