(ns scribe.time.joda.date-time
  "Utilities and implementations of `scribe.time.core` conversions for
  `org.joda.time.LocalTime`."
  (:require [scribe.time.core :as cs])
  (:import [org.joda.time DateTime DateTimeZone Instant]))

(def ^DateTimeZone ^:private utc (DateTimeZone/UTC))

(defn ^DateTime now [] (DateTime/now))

(defmethod cs/instant? org.joda.time.DateTime [_] true)

(defmethod cs/to-epoch-milli org.joda.time.DateTime
  [^DateTime dt]
  (-> dt (.toDateTime utc) .toInstant .getMillis))

(defmethod cs/of-epoch-milli org.joda.time.DateTime
  [_ ^long ms]
  (-> ms Instant. (DateTime. utc)))
