(ns scribe.time.java8.local-time
  "Utilities and implementations of `scribe.time.core` conversions for Java 8
  `java.time.LocalTime`."
  (:require [scribe.time.core :as t]
            [scribe.time.utils :as u])
  (:import java.time.LocalTime))

(defn ^LocalTime now [] (LocalTime/now))
(defmethod t/local-time? java.time.LocalTime [_] true)

(defmethod t/to-milli-of-day java.time.LocalTime
  [^LocalTime lt]
  (-> lt .toNanoOfDay u/nanos->millis!))

(defmethod t/of-milli-of-day java.time.LocalTime
  [_ ms]
  (LocalTime/ofNanoOfDay (u/millis->nanos ms)))

(defmethod t/to-micro-of-day java.time.LocalTime
  [^LocalTime lt]
  (-> lt .toNanoOfDay u/nanos->micros!))

(defmethod t/of-micro-of-day java.time.LocalTime
  [_ µs]
  (LocalTime/ofNanoOfDay (u/micros->nanos µs)))
