(defproject vise890/scribe "0.1.0-SNAPSHOT"
  :description "Schema transformation engine for Spec, Avro. ..."

  :url "https://gitlab.com/vise890/scribe"

  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}

  :dependencies [[camel-snake-kebab "0.4.0"]
                 [org.apache.avro/avro "1.8.2"]
                 [com.damballa/abracad "0.4.13" :exclusions [org.apache.avro/avro]]
                 [medley "1.0.0"]
                 [org.clojure/clojure "1.9.0"]
                 [org.clojure/spec.alpha "0.1.143"]
                 ;; TODO move to something like clojure.core `with-class`
                 [clj-time "0.14.2"]

                 [ch.qos.logback/logback-classic "1.2.3"]
                 [ch.qos.logback/logback-core "1.2.3"]
                 [org.clojure/tools.logging "0.4.0"]]

  :plugins [[lein-codox "0.10.3"]]

  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version"
                   "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag"]
                  ["vcs" "push"]
                  ["change" "version"
                   "leiningen.release/bump-version"]
                  ["vcs" "commit"]]

  :profiles {:dev {:dependencies [[expound "0.5.0"]
                                  [fipp "0.6.12"]
                                  [org.clojure/test.check "0.10.0-alpha2"]]
                   :resource-paths ["dev/resources"]}

             :ci {:deploy-repositories
                  [["clojars" {:url           "https://clojars.org/repo"
                               :username      :env
                               :password      :env
                               :sign-releases false}]]}})
