(ns scribe.conformer
  (:require [clojure.spec.alpha :as s]))

;; TODO explore spec's specs.. see if we can reuse some of that stuff

(s/def :scribe.conformer.fn/name qualified-keyword?)
(s/def :scribe.conformer.fn/map
  (s/keys :req [:scribe.conformer.fn/name]))
(s/def :scribe.conformer.fn/form
  (s/cat :fn-sym (partial = `fn)
         :arglist vector?
         :scribe.conformer.fn/map :scribe.conformer.fn/map
         :rest (s/* any?)))
(s/def :scribe.conformer/form
  (s/cat :conformer (partial = `s/conformer)
         :f (s/spec :scribe.conformer.fn/form)
         :unf (s/? (s/spec :scribe.conformer.fn/form))))


(defn scribe-conformer? [form] (s/valid? ::form form))

(defn f-map [form]
  (get-in (s/conform ::form form)
          [:f :scribe.conformer.fn/map]))

(defn unf-map [form]
  (get-in (s/conform ::form form)
          [:unf :scribe.conformer.fn/map]))

(defn f-name [form]
  (-> form f-map :scribe.conformer.fn/name))

(defn unf-name [form]
  (-> form unf-map :scribe.conformer.fn/name))
