(ns scribe.decimal
  (:require [clojure.spec.alpha :as s]))

(defn ->scale-conformer [scale]
  (s/conformer
   (fn [^BigDecimal bd]
     (try
       (.setScale bd scale)
       (catch ArithmeticException _
         :clojure.spec.alpha/invalid)))))

(defn set-precision [^BigDecimal bd precision]
  (let [prec (+ (.scale bd) (- precision (.precision bd)))]
    (.setScale bd prec)))

(defn ->precision-conformer [precision]
  (s/conformer
   (fn [bd]
     (try
       (set-precision bd precision)
       (catch ArithmeticException _
         :clojure.spec.alpha/invalid)))))
