# scribe [![pipeline status](https://gitlab.com/vise890/scribe/badges/master/pipeline.svg)](https://gitlab.com/vise890/scribe/commits/master)

Schema transformation engine for clojure.spec, Avro, ...

## [API Docs](https://vise890.gitlab.io/scribe/)

## Usage

[![Clojars
Project](https://img.shields.io/clojars/v/vise890/scribe.svg)](https://clojars.org/vise890/scribe)

```clojure
;;; project.clj
[vise890/scribe "0.1.0-SNAPSHOT"]
```

```clojure

(require '[clojure.test :as t])
(require '[scribe.avro.core :as savro])
(require '[clojure.spec.alpha :as s])

(s/def :my.ns/string string?)
(s/def :my.ns/decimal decimal?)
(s/def :my.ns/enum #{:beep :boop})
(s/def :my.ns/collOf (s/coll-of string?))
(s/def :my.ns/recordOne
  (s/keys :req-un [:my.ns/string
                   :my.ns/decimal
                   :my.ns/enum
                   :my.ns/collOf]))
(s/def :my.ns/recordTwo
  (s/keys :req-un [:my.ns/string
                   :my.ns/decimal
                   :my.ns/enum
                   :my.ns/recordOne]))
(s/def :my.ns/or
  (s/or :r1 :my.ns/recordOne
        :r2 :my.ns/recordTwo))

;; generate an avro schema
(def avro-schema (savro/->avro-schema :my.ns/or))

(def record1
  {:string "uio8",
   :decimal 0.43M,
   :enum :beep,
   :collOf ["G3" "R7" "xr98"]})

(def record2
  {:string "3G6A",
   :decimal -0.125M,
   :enum :boop,
   :recordOne record1})
   
;; NOTE takes care of decimal -> bytes & friends
(->> record1
     (savro/binary-encoded :my.ns/or)
     (savro/decode :my.ns/or)
     (= record1))
```

## License

Copyright © 2017 Martino Visintin

Distributed under the Eclipse Public License either version 1.0 or (at your
option) any later version.
