(ns scribe.spec.core
  "Scribe spec to Clojure Spec conversions."
  (:require [clojure.spec.alpha :as s]
            scribe.specs))

(declare ->clj-spec)

(defmulti ^:private ->clj-spec scribe.specs/variant)

;; TODO actually check precision and scale
(defmethod ->clj-spec :scribe/decimal [_] decimal?)

(defmethod ->clj-spec :scribe/string [_] string?)

(defmethod ->clj-spec :scribe/boolean [_] boolean?)

(defmethod ->clj-spec :scribe/enum [scribe-spec]
  `(s/and (s/conformer keyword)
         (:scribe.enum/keywords ~scribe-spec)))


(defmethod ->clj-spec :scribe/coll-of [scribe-spec]
  (let [p            (:scribe/coll-of scribe-spec)
        coll-of-pred (->clj-spec p)]
    `(s/coll-of ~coll-of-pred)))

(defmethod ->clj-spec :scribe/or [scribe-spec]
  (let [or-args (->> (:scribe/or scribe-spec)
                     (mapcat (fn [m] [m (->clj-spec m)])))]
    `(s/or ~@or-args)))

(defmethod ->clj-spec :default [scribe-spec] scribe-spec)

(s/fdef defspec
        :args (s/cat :spec-name qualified-keyword?
                     :scribe-spec :scribe/spec))
(defmacro defspec [spec-name scribe-spec]
  `(s/def ~spec-name ~(->clj-spec scribe-spec)))

(s/fdef defspecs
        :args (s/cat :registry :scribe/registry))
(defmacro defspecs [registry]
  `(do ~@(for [[spec-name# scribe-spec#] registry]
           `(s/def ~spec-name# ~(->clj-spec scribe-spec#)))))
