(ns scribe.spec.core
  "Scribe spec to Clojure Spec conversions."
  (:require [clojure.spec.alpha :as s]
            scribe.specs))

(declare ->clj-spec)

;; TODO actually check precision and scale
(defmacro ->clj-spec:decimal [_] decimal?)

(defmacro ->clj-spec:coll-of [scribe-spec]
  (let [p            (:scribe/coll-of scribe-spec)
        coll-of-pred `(->clj-spec ~p)]
    `(s/coll-of ~coll-of-pred)))

(defmacro ->clj-spec:or [scribe-spec]
  (let [or-args (->> (:scribe/or scribe-spec)
                     (mapcat (fn [m] [m `(->clj-spec ~m)])))]
    `(s/or ~@or-args)))

(defmacro ->clj-spec [scribe-spec]
  (condp = (scribe.specs/variant scribe-spec)
    :scribe/string  `string?
    :scribe/boolean `boolean?
    :scribe/decimal `(->clj-spec:decimal ~scribe-spec)
    :scribe/coll-of `(->clj-spec:coll-of ~scribe-spec)
    :scribe/or      `(->clj-spec:or ~scribe-spec)
    scribe-spec))

(defmacro defspec [spec-name scribe-spec]
  `(s/def ~spec-name (->clj-spec ~scribe-spec)))

(defmacro defspecs [registry]
  `(do ~@(for [[spec-name# scribe-spec#] registry]
           `(s/def ~spec-name# (->clj-spec ~scribe-spec#)))))
