(ns scribe.avro.serde-utils
  "Utils for the massaging of values before serializing to/after deserializing
  from Avro.")

(defn big-decimal->unscaled-int-bytes
  "Converts big-decimal with scale to the bytes of a big integer."
  [^Integer scale big-decimal]
  ;; FIXME assert precision here?!?
  (-> big-decimal
      (.movePointRight scale)
      (.toBigIntegerExact)
      (.toByteArray)))

(defn unscaled-int-bytes->big-decimal
  "Converts bytes to a BigDecimal with the specified scale."
  [^Integer scale bytes]
  ;; FIXME assert precision here?!?
  (-> bytes
      (BigInteger.)
      (BigDecimal. scale)))
