(ns pocketbook.core
  (:require [cemerick.pomegranate :as pome]
            [cemerick.pomegranate.aether :as aether]))

(defn- deps->sources+javadocs
  [coordinate]
  (->> coordinate
       (mapcat (fn [c]
                 ;; TODO handle things that already have a classifier
                 ;; TODO remove :exclusions and friends?
                 [(conj c :classifier "sources")
                  (conj c :classifier "javadoc")]))))

(defn- try-add-dependency
  [coordinate]
  (try
    (pome/add-dependencies :coordinates [coordinate])
    (println "Added" coordinate)
    (catch org.eclipse.aether.resolution.DependencyResolutionException _)))

(defn- resolve-dependencies
  [coordinates]
  (keys (aether/resolve-dependencies :retrieve false :coordinates coordinates)))

(defn add-sources+javadocs
  "Tries to add the source and javadoc artefacts to the current runtime.
  NOTE pulls down the entire graph..."
  [coordinates]
  (doseq [c (->> coordinates
                 resolve-dependencies
                 deps->sources+javadocs)]
    (try-add-dependency c)))

;; TODO turn into leiningen plugin /library

;; TODO add java lang sources
;; NOTE seems to work if openjdk8-src is installed???
;; (pome/add-classpath "/usr/lib/jvm/default/src.zip")
;; (fs/normalized (io/file (System/getProperty "java.home") ".." "src.zip"))
