(ns dbwalk.query-parser
  "Simple getters for parsing the query tree."
  (:require [schema.core :as s]
            [dbwalk.schemas :refer :all]
            [dbwalk.relations :as relation]))



(s/defn query [node :- QueryTree]
  (:dbwalk/query node))

(s/defn from [node :- QueryTree]
  (first (:from (query node))))

(s/defn data-source-and-type [node :- QueryTree]
  (select-keys node [:dbwalk/data-source-id :dbwalk/data-source-type]))

(s/defn children [node :- QueryTree]
  (get node :dbwalk/eager []))

(s/defn selected [node :- QueryTree]
  (:select (query node)))


(defmulti compare-target-with-query "Compares a QueryTree node to Relation's target"
          (fn [query-tree relation]
            (:dbwalk/data-source-type query-tree)))

(defmethod compare-target-with-query :default [query-tree relation]
  (and
    (= (relation/to-data-source relation) (data-source-and-type query-tree))
    (= (relation/target-table relation) (from query-tree))))

(defmulti compare-source-with-query "Compares a QueryTree node to Relation's source"
          (fn [query-tree relation]
            (:dbwalk/data-source-type query-tree)))

(defmethod compare-source-with-query :default [query-tree relation]
  (and
    (= (relation/from-data-source relation) (data-source-and-type query-tree))
    (= (relation/source-table relation) (from query-tree))))

