(ns dbwalk.output.flat
  "Flat output, where rows are grouped by table and the structure of the data is ignored."
  (:require [dbwalk.relations :as relation]
            [dbwalk.graph :as graph]
            [dbwalk.entity-node :as en]
            [dbwalk.utils :as utils]))


(defn- extract-data [m]
  (into {} (for [[k v] m] [k (apply hash-set (map en/data v))])))

(defn graph->flat [graph]
  (->> (graph/nodes graph)
       (group-by #(relation/target-table (en/relation %)))
       (extract-data)))

(defn- find-pk [graph entity]
  (let [primary-key-value (get (en/data entity) (graph/primary-key-column graph entity))]
    {primary-key-value entity}))

(defn- seq->pk-map [graph entities]
  (->> entities
       (map (partial find-pk graph))
       (apply merge)))

(defn- data-only [m]
  (into {} (for [[k v] m] [k (apply hash-set (map en/data v))])))

(defn graph->primary-key-mapping [graph]
  (->> (graph/nodes graph)
       (group-by #(relation/target-table (en/relation %)))
       (utils/map-vals (partial seq->pk-map graph))
       (utils/map-vals #(utils/map-vals en/data %))))


