(ns dbwalk.entity-node
  (:require [schema.core :as s]))

(s/defschema EntityNode
  "Format for storing database rows in the result graph."
  {:dbwalk/relation    s/Any
   :dbwalk/entity-data s/Any})

(s/defn relation [node :- EntityNode]
  (:dbwalk/relation node))

(s/defn data [node :- EntityNode]
  (:dbwalk/entity-data node))

(s/defn wrap-entities :- [EntityNode]
  [relation entities]
  (map #(hash-map :dbwalk/relation relation :dbwalk/entity-data %) entities))

(s/defn unwrap-entities [nodes :- [EntityNode]]
  (map data nodes))

(def ^:private node-checker (s/checker EntityNode))

(defn- drop-relation [node]
  (if (nil? (node-checker node))
    (data node)
    node))

(defn data-only [tree]
  (clojure.walk/postwalk drop-relation tree))
