(ns dbwalk.api.vector
  "A helper function for generating queries from nested vectors."
  (:require [honeysql.helpers :as sql]))


(defn vec->query-tree
  "Takes a nested vector representing a nested query and returns a query-tree without datasource information.

   Inside a vector,
    * the first keyword is the target table. If missing, throws IllegalArgumentException.
    * the first set of keywords contains the columns to select (default :*).
    * the first map contains a base query to start from. SELECT and FROM clauses will be overwritten.
    * contained vectors are handled recursively and placed under the :dbwalk/eager key."
  [v]
  (let [table         (first (filter keyword? v))
        columns       (or (first (filter set? v)) #{:*})
        initial-query (first (filter map? v))
        children      (filter vector? v)]
    (if table
      (merge {:dbwalk/query (merge initial-query
                                   (-> (apply sql/select columns)
                                       (sql/from table)))}
             (when (seq children)
               {:dbwalk/eager (mapv vec->query-tree children)}))
      (throw (IllegalArgumentException. (str "Missing table in vector: " v))))))
