(ns dbwalk.action.writer
  "WORK IN PROGRESS. Everything under dbwalk.action is only included in master because they are used for tests.
   Not to be used in production.\n

   Utility for applying operations to the database.
   The input is a Loom digraph where the edges between nodes represent the action ordering.
   This allows correct insertion/deletion ordering by always handling
   nodes (rows) with no incoming edges, pushing the generated primary key to its children
   and repeating until the graph is empty. Each node must have a db operation (see v.d.a.operations) as an attr."

  (:require [dbwalk.graph :as graph]
            [dbwalk.action.operations :as ops]
            [dbwalk.utils :as utils]))

(defn- extract-primary-key [configuration data-source table entity]
  (get entity (utils/primary-key-column configuration data-source table)))

(defn- apply-op-for-single-entity [configuration input-graph entity]
  (let [{:keys [dbwalk/data-source dbwalk/table-name dbwalk/entity-data]} (graph/get-data-for-node input-graph entity)
        operation      (graph/operation input-graph entity)
        updated-entity (ops/apply-operation! configuration data-source operation table-name entity-data)
        primary-key    (extract-primary-key configuration data-source table-name updated-entity)]
    (when-not (= operation :delete)
      (graph/update-key-to-children! input-graph entity primary-key))
    (graph/remove-node input-graph entity)))

(defn apply-operations [configuration input-graph]
  (when-let [first-level-data (seq (graph/root-items input-graph))]
    (run! #(apply-op-for-single-entity configuration input-graph %) first-level-data)
    (recur configuration input-graph)))

