(ns dbwalk.action.operations
  "Operations that can be applied to rows in the database. :no-op is used for anchoring the data to existing rows.
   For example, when adding new children to a parent, the parent node can have :no-op as its operation
   to avoid unnecessary writes.")

(def all-operations #{:insert :delete :update :no-op})

(defmulti apply-operation!
          (fn [configuration data-source-description operation table entity]
            (:dbwalk/data-source-type data-source-description)))
