(defproject vincit/dbwalk "0.2.2-SNAPSHOT"
  :description "Clojure library for getting your data from a db as nested maps."
  :url "https://bitbucket.org/vincit/db-walk"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.8.0"]
                 [org.clojure/java.jdbc "0.6.1"]

                 ;; Logging
                 [org.clojure/tools.logging "0.3.1"]

                 ;; SQL DSL
                 [honeysql "0.7.0"]

                 ;; Graph
                 [aysylu/loom "0.6.0"]

                 ;; Parameter typing for development time
                 [prismatic/schema "1.1.0"]

                 ;; Utils
                 [prismatic/plumbing "0.5.3"]

                 ;; API structuring
                 [potemkin "0.4.3"]]

  :profiles {:dev {:dependencies [[org.clojure/tools.namespace "0.2.11"]
                                  [com.rpl/specter "0.11.2"]
                                  [org.clojure/tools.nrepl "0.2.11"]
                                  [org.postgresql/postgresql "9.4.1208"]
                                  [ragtime "0.6.0"]]}}



  :jar-exclusions [#".*migrations.*" #".*log4j.properties"])

