(ns vincit.dbwalk.config
  "A simple parser for the database schema description."
  (:require [vincit.dbwalk.relations :refer :all]
            [vincit.dbwalk.database.sql :as sql]))


(defmulti parse-relation (fn [relation table-name primary-keys data-source]
                           (:type relation)))

(defmethod parse-relation :many-to-one [relation table-name primary-keys data-source]
  (let [{:keys [type target column-name]} relation]
    (->ManyToOne data-source (sql/->ColumnSpec table-name column-name)
                 data-source (sql/->ColumnSpec target (get primary-keys target)))))

(defn- get-primary-key-for-table [table-config]
  (let [{:keys [name primary-key]} table-config]
    {name primary-key}))

(defn- extract-relations-from-table [primary-keys data-source table-config]
  (map #(parse-relation % (:name table-config) primary-keys data-source)
       (or (:dbwalk/relations table-config) [])))

(defn- extract-relations [primary-keys config data-source]
  (map (partial extract-relations-from-table primary-keys data-source) config))

(defn- primary-keys-by-table [config]
  (into {} (map get-primary-key-for-table config)))

;; TODO: Add a way to merge other relations to these while retaining ability to automatically invert them.
(defn parse-config
  "Parses the database description. Generates one-to-many -relations from many-to-one -relations."
  [config data-source]
  (let [primary-keys (primary-keys-by-table config)
        relations    (flatten (extract-relations primary-keys config data-source))]
    {:dbwalk/relations    (group-by from-data-source
                                    (concat relations (map get-inverse-relation relations)))
     :dbwalk/primary-keys {data-source primary-keys}}))
