(ns vincit.dbwalk.schemas
  (:require [schema.core :as s]
            [vincit.dbwalk.relations :as relations]))

(def DataSourceDescription
  {:dbwalk/data-source-id   s/Keyword
   :dbwalk/data-source-type s/Keyword})


(def Configuration {:dbwalk/relations                     {DataSourceDescription [(s/protocol relations/Relation)]}
                    :dbwalk/data-sources                  {s/Keyword s/Any}
                    (s/optional-key :dbwalk/primary-keys) {DataSourceDescription {s/Keyword (s/maybe s/Keyword)}}
                    s/Keyword                             s/Any}) ;; Allow extension


(def MultiMap {s/Keyword #{s/Keyword}})

(def QueryPath {:dbwalk/query-path-start (s/maybe s/Keyword) ;; Start node
                :dbwalk/links            MultiMap})         ;; Node to successors


(s/defschema QueryTree
  "Format for nested database queries."
  {(s/required-key :dbwalk/data-source-id)   s/Keyword
   (s/required-key :dbwalk/data-source-type) s/Keyword
   (s/required-key :dbwalk/query)            (s/pred map?)
   (s/optional-key :dbwalk/eager)            [(s/recursive #'QueryTree)]})


(s/defschema NamespacedKeyword
  (s/pred #(and (keyword? %)
                (not (nil? (namespace %))))))
