(ns vincit.dbwalk.input.filter-data
  (:require [schema.core :as s]
            [plumbing.core :as pl]))


(def FilterData {s/Keyword #{s/Keyword}})

(defn- split-namespaced-keywords
  "Splits :namespace/name to [:namespace :name]"
  [kws]
  (map (juxt (comp keyword namespace) (comp keyword name)) kws))

(defn- kw-pairs-to-set [kw-pairs]
  (->> kw-pairs
       (map second)
       (apply hash-set)))

(s/defn columns-to-filter-data :- FilterData
  "Generates a filter for the filtered input/output formats from a list of keywords (:table/column)"
  [columns :- [s/Keyword]]
  (->> columns
       (split-namespaced-keywords)
       (group-by first)
       (pl/map-vals kw-pairs-to-set)))

