(ns vincit.dbwalk.utils
  (:require [vincit.dbwalk.schemas :refer :all]
            [schema.core :as s]
            [clojure.walk :as walk]))

(defn map-vals [f m]
  (zipmap (keys m) (map f (vals m))))

(defn- merge-if-query [primary secondary]
  (if (and (map? primary)
           (contains? primary :dbwalk/query))
    (merge secondary primary)
    primary))

(s/defn with-datasource :- QueryTree
  "Merges the given data-source map with all queries in the query-tree,
                        not overwriting existing definitions"
  [data-source query-tree]
  (walk/postwalk #(merge-if-query % data-source) query-tree))

(defn first-datasource
  "Takes a random datasource from configuration.
  This is a helper function that can simplify writing your own API when only one datasource is used."
  [config]
  (first (keys (:dbwalk/relations config))))

(defn default-datasource
  "Returns a DatasourceDescription with the given database-id and default :dbwalk/data-source-type."

  [db-id]
  {:dbwalk/data-source-id   db-id
   :dbwalk/data-source-type :dbwalk/jdbc-sql})

(defn primary-key-column [configuration data-source-description table]
  (-> configuration
      (get-in [:dbwalk/primary-keys data-source-description])
      (get table)))

(defn- remove-namespaces [m]
  (if (map? m)
    (zipmap (map #(keyword (name %)) (keys m)) (vals m))
    m))

(defn without-namespaces [data]
  (walk/postwalk remove-namespaces data))