(ns vincit.dbwalk.schemas
  (:require [schema.core :as s]
            [vincit.dbwalk.relations :as relations]))

(def DataSourceDescription
  {:data-source s/Keyword
   :type        s/Keyword})


(def Configuration {:dbwalk/relations                     {(s/pred map?) [(s/protocol relations/Relation)]}
                    :dbwalk/data-sources                  s/Any
                    (s/optional-key :dbwalk/primary-keys) {DataSourceDescription {s/Keyword (s/maybe s/Keyword)}}
                    s/Keyword                             s/Any}) ;; Allow extension


(def MultiMap {s/Keyword #{s/Keyword}})

(def QueryPath {:start    (s/maybe s/Keyword)               ;; Start node
                :link-map MultiMap})                        ;; Node to successors


(s/defschema QueryTree
  "Format for nested database queries."
  {(s/required-key :data-source) s/Keyword
   (s/required-key :type) s/Keyword
   (s/required-key :query) (s/pred map?)
   (s/optional-key :eager) [(s/recursive #'QueryTree)]})


(s/defschema NamespacedKeyword
  (s/pred #(and (keyword? %)
                (not (nil? (namespace %))))))
