(ns vincit.dbwalk.input.filtered
  "Implements the 'filtered' query generator function, which allows selecting only required attributes and tables."
  (:require    [vincit.dbwalk.api.tree-map :as tree]
               [vincit.dbwalk.schemas :refer :all]
               [schema.core :as s]
               [vincit.dbwalk.input.filter-data :refer :all]))


(s/defn query-for-columns
        "Generates a minimal QueryTree using the QueryPath so that
        - all columns are included in the result
        - the queries in the base-queries map {table -> HoneySQL query} are merged with the generated QueryTree nodes.
        SELECT and FROM clauses will be generated solely based on columns-to-select
        and any such clauses in partial-queries-by-table will be ignored.
        Throws an exception when a QueryTree cannot be generated."
        (
          [path :- QueryPath
           columns :- [s/Keyword]
           base-queries :- {s/Keyword s/Any}]
          (let [filter-data (columns-to-filter-data columns)
                nodes (apply hash-set (keys filter-data))
                subtree (tree/covering-subtree path nodes)]
            (if (nil? subtree)
              (throw (ex-info "Cannot find subtree" {:path path :columns columns})))
            (tree/query-from-path subtree filter-data base-queries)))

        (
          [path :- QueryPath
           columns :- [s/Keyword]]
          (query-for-columns path columns {})))


