(ns vincit.dbwalk.entity-node
  (:require [schema.core :as s]))

(s/defschema EntityNode
  "Format for storing database rows in the result graph."
  {:join s/Any
   :data s/Any})

(s/defn join [node :- EntityNode]
  (:join node))

(s/defn data [node :- EntityNode]
  (:data node))

(s/defn wrap-entities :- [EntityNode]
  [join entities]
  (map #(hash-map :join join :data %) entities))

(s/defn unwrap-entities [nodes :- [EntityNode]]
  (map data nodes))

(def ^:private node-checker (s/checker EntityNode))

(defn- drop-join [node]
  (if (nil? (node-checker node))
    (data node)
    node))

(defn data-only [tree]
  (clojure.walk/postwalk drop-join tree))
